/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ParticleInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnderwarthogEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> RARE_VARIANT = SynchedEntityData.m_135353_(EnderwarthogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BITE_ATTACK = SynchedEntityData.m_135353_(EnderwarthogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int sprintedTicker = 0;

    public EnderwarthogEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 10;
    }

    public static AttributeSupplier.Builder createEnderwarthogAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 38.0);
    }

    public static boolean canSpawn(EntityType<EnderwarthogEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        BlockState blockState = world.m_8055_(pos);
        return world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Monster.m_217057_(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && random.m_188503_(6) == 0 && NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), EntityInit.ENDERWARTHOG);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SprintAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HeadAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.85));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EnderwarthogEntity.class}));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EnderDragon.class}));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EnderMan.class}));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Endermite.class}));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Shulker.class}));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SprintTicker", this.sprintedTicker);
        tag.m_128379_("RareVariant", ((Boolean)this.f_19804_.m_135370_(RARE_VARIANT)).booleanValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.sprintedTicker = tag.m_128451_("SprintTicker");
        this.f_19804_.m_135381_(RARE_VARIANT, (Object)tag.m_128471_("RareVariant"));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RARE_VARIANT, (Object)false);
        this.f_19804_.m_135372_(BITE_ATTACK, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.sprintedTicker > 0) {
            --this.sprintedTicker;
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    protected SoundEvent m_7515_() {
        return SoundInit.ENDERWARTHOG_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.ENDERWARTHOG_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.ENDERWARTHOG_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.ENDERWARTHOG_WALK_EVENT, 0.15f, 1.0f);
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundInit.ENDERWARTHOG_ATTACK_EVENT, SoundSource.HOSTILE, 1.0f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
        return super.m_7327_(target);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorldAccess, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        entityData = super.m_6518_(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
        if (spawnReason.equals((Object)MobSpawnType.COMMAND)) {
            this.f_19804_.m_135381_(RARE_VARIANT, (Object)true);
        }
        if ((spawnReason.equals((Object)MobSpawnType.NATURAL) || spawnReason.equals((Object)MobSpawnType.CHUNK_GENERATION)) && this.m_9236_().m_213780_().m_188501_() <= ConfigInit.CONFIG.warthog_rare_chance) {
            this.f_19804_.m_135381_(RARE_VARIANT, (Object)true);
            this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) + 20.0);
        }
        return entityData;
    }

    private class SprintAttackGoal
    extends Goal {
        private final EnderwarthogEntity enderwarthogEntity;
        private Vec3 targetPos;
        private int cooldown;

        public SprintAttackGoal(EnderwarthogEntity enderwarthogEntity2) {
            this.enderwarthogEntity = enderwarthogEntity2;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldown-- > 0) {
                return false;
            }
            LivingEntity livingEntity = this.enderwarthogEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (this.enderwarthogEntity.m_142582_((Entity)livingEntity) && Math.abs(livingEntity.m_20186_() - this.enderwarthogEntity.m_20186_()) <= 3.0 && livingEntity.m_20096_()) {
                this.targetPos = livingEntity.m_20182_();
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.enderwarthogEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (this.attack(livingEntity, this.enderwarthogEntity.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_()))) {
                return false;
            }
            if (this.enderwarthogEntity.m_20275_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_()) < 10.0) {
                return false;
            }
            if (!(livingEntity instanceof Player) || livingEntity.m_5833_() || ((Player)livingEntity).m_7500_()) {
                return false;
            }
            Vec3 vec3d = new Vec3(this.enderwarthogEntity.m_20185_(), this.enderwarthogEntity.m_20188_(), this.enderwarthogEntity.m_20189_());
            Vec3 vec3d2 = new Vec3(this.targetPos.m_7096_() - this.enderwarthogEntity.m_20185_(), this.targetPos.m_7098_() + 1.8, this.targetPos.m_7094_() - this.enderwarthogEntity.m_20189_()).m_82541_().m_82542_(8.0, 0.0, 8.0);
            BlockHitResult blockHitResult = this.enderwarthogEntity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d.m_82549_(vec3d2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.enderwarthogEntity));
            return blockHitResult.m_6662_() != HitResult.Type.BLOCK && !this.enderwarthogEntity.m_9236_().m_8055_(blockHitResult.m_82425_().m_6625_(3)).m_60795_();
        }

        public void m_8056_() {
            double d = this.targetPos.m_7096_() - this.enderwarthogEntity.m_20185_();
            double e = this.targetPos.m_7094_() - this.enderwarthogEntity.m_20189_();
            this.targetPos = this.targetPos.m_82520_(new Vec3((double)d, (double)0.0, (double)e).m_82541_().f_82479_ * 10.0, 0.0, new Vec3((double)d, (double)0.0, (double)e).m_82541_().f_82481_ * 10.0);
        }

        public void m_8037_() {
            double d = this.targetPos.m_7096_() - this.enderwarthogEntity.m_20185_();
            double e = this.targetPos.m_7094_() - this.enderwarthogEntity.m_20189_();
            float q = (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
            this.enderwarthogEntity.m_146922_(this.wrapDegrees(this.enderwarthogEntity.m_146908_(), q, 90.0f));
            this.enderwarthogEntity.m_6478_(MoverType.SELF, new Vec3(d, 0.0, e).m_82541_().m_82490_(0.6));
            if (!this.enderwarthogEntity.m_9236_().m_5776_()) {
                Vec3 vec3d2 = new Vec3(this.targetPos.m_7096_() - this.enderwarthogEntity.m_20185_(), this.targetPos.m_7098_() + 1.8, this.targetPos.m_7094_() - this.enderwarthogEntity.m_20189_()).m_82541_();
                ((ServerLevel)EnderwarthogEntity.this.m_9236_()).m_8767_((ParticleOptions)ParticleInit.SPRINT_PARTICLE, this.enderwarthogEntity.m_20208_(0.7), this.enderwarthogEntity.m_20187_(), this.enderwarthogEntity.m_20262_(0.7), 0, vec3d2.f_82479_, 0.0, vec3d2.f_82481_, 1.0);
            }
        }

        public void m_8041_() {
            this.cooldown = 100 + this.enderwarthogEntity.m_9236_().m_213780_().m_188503_(100);
            this.enderwarthogEntity.m_21561_(false);
            this.enderwarthogEntity.sprintedTicker = 40;
            super.m_8041_();
        }

        private boolean attack(LivingEntity target, double squaredDistance) {
            double d = this.enderwarthogEntity.m_20205_() * 1.5f * this.enderwarthogEntity.m_20205_() * 1.5f + target.m_20205_();
            if (squaredDistance <= d) {
                this.enderwarthogEntity.m_6674_(InteractionHand.MAIN_HAND);
                if (this.enderwarthogEntity.m_7327_((Entity)target)) {
                    Vec3 attackedPos = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    if (!this.enderwarthogEntity.m_9236_().m_8055_(BlockPos.m_274446_((Position)attackedPos).m_7495_()).m_60795_()) {
                        for (int i = 0; i < 30; ++i) {
                            ((ServerLevel)EnderwarthogEntity.this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.enderwarthogEntity.m_9236_().m_8055_(BlockPos.m_274446_((Position)attackedPos).m_7495_())), attackedPos.m_7096_() + this.enderwarthogEntity.m_9236_().m_213780_().m_188500_() * 2.5 - 1.25, attackedPos.m_7098_() + this.enderwarthogEntity.m_9236_().m_213780_().m_188500_() * 0.2, attackedPos.m_7094_() + this.enderwarthogEntity.m_9236_().m_213780_().m_188500_() * 2.5 - 1.25, 4, 0.0, this.enderwarthogEntity.m_9236_().m_213780_().m_188500_() * 0.15, 0.0, 1.0);
                        }
                    }
                    target.m_20256_(target.m_20184_().m_82520_(0.0, 0.1, 0.0));
                    target.m_147240_(3.0, (double)Mth.m_14031_((float)(this.enderwarthogEntity.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.enderwarthogEntity.m_146908_() * ((float)Math.PI / 180)))));
                }
                return true;
            }
            return false;
        }

        private float wrapDegrees(float from, float to, float max) {
            float g;
            float f = Mth.m_14177_((float)(to - from));
            if (f > max) {
                f = max;
            }
            if (f < -max) {
                f = -max;
            }
            if ((g = from + f) < 0.0f) {
                g += 360.0f;
            } else if (g > 360.0f) {
                g -= 360.0f;
            }
            return g;
        }
    }

    private class HeadAttackGoal
    extends MeleeAttackGoal {
        private final EnderwarthogEntity enderwarthogEntity;
        private int cooldown;

        public HeadAttackGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.enderwarthogEntity = (EnderwarthogEntity)mob;
        }

        public boolean m_8036_() {
            if (this.enderwarthogEntity.sprintedTicker > 0) {
                return false;
            }
            return super.m_8036_();
        }

        protected double m_6639_(LivingEntity entity) {
            return this.f_25540_.m_20205_() * 1.6f * this.f_25540_.m_20205_() * 1.5f + entity.m_20205_();
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.enderwarthogEntity.f_19804_.m_135381_(BITE_ATTACK, (Object)true);
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)target);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.enderwarthogEntity.f_19804_.m_135381_(BITE_ATTACK, (Object)false);
        }
    }
}

